/*---------------------------------------------------
  չOWRAM W24257AK(32KB)O_ॿ`sC
  }:0000 ~ 7FFF
  CӦ}(Byte)eX0x55AŪAeX0xAAAŪA
  ܨ}AY~hCܭȧY~}C
  ӦƤܡA`̫ܳ|b3276C

    2024/02/07
-----------------------------------------------------*/
#include "reg52.h"
#include <stdio.h>
#include <stdlib.h>
#include <String.h>
#include <absacc.h>
#include <intrins.h>

// Define port
sbit clk = P1^3;
sbit dio = P1^1;

#define RAM_START 0x0000  //RAM start address
#define RAM_END   0x7FFF  //RAM end address
int num[5];    //array for display

const unsigned char code seg_data[13] =   //TM1637 Fonts
{
    0x3F, // 0
    0x06, // 1
    0x5B, // 2
    0x4F, // 3
    0x66, // 4
    0x6D, // 5
    0x7D, // 6
    0x07, // 7
    0x7F, // 8
    0x6F, // 9 
    0x00, // none
    0x03, // :
    0x04  // .  
};

//========== TM1637 Functions =========================
void Delay_us (unsigned int i) // n us delay
{
    for (; i> 0; i--)
        nop_ ();
}
//----------------------------------------------------
void I2CStart (void) // 1637 start
{
    clk = 1;
    dio = 1;
    Delay_us (2);
    dio = 0;
}
//----------------------------------------------------
void I2Cask (void) // 1637 Answer
{
    clk = 0;
    Delay_us (5); // After the falling edge of the eighth clock delay 5us, ACK signals the beginning of judgment
    while (dio);
    clk = 1;
    Delay_us (2);
    clk = 0;
}
//----------------------------------------------------
void I2CStop (void) // 1637 Stop
{
    clk = 0;
    Delay_us (2);
    dio = 0;
    Delay_us (2);
    clk = 1;
    Delay_us (2);
    dio = 1;
}
//----------------------------------------------------
void I2CWrByte (unsigned char oneByte) // write a byte
{
    unsigned char i;
    for (i = 0; i <8; i++)
    {
        clk = 0;
        if (oneByte & 0x01)   // low front
            dio = 1;
        else 
            dio = 0;
        Delay_us (3);
        oneByte = oneByte >> 1;
        clk = 1;
        Delay_us (3);
   }
}
//-----------------------------------------------
void DisplayNum(int num[5]) // Write display register
{
    unsigned char i; 
    I2CStart();
    I2CWrByte(0x40); //40H address is automatically incremented by 1 mode, 44H fixed address mode
    I2Cask();
    I2CStop();
    I2CStart();
    I2CWrByte(0xC0); // Set the address, 0xC0 is first
    I2Cask();
    for(i=0;i<5;i++) // Addresses from Canada, do not always write address
    {
        if(i == 2)
            I2CWrByte(seg_data[num[i]] | 0x80); // Send data
        else
            I2CWrByte(seg_data[num[i]]); // Send data
        I2Cask();
    }
    I2Cask();
    I2CStop();
    I2CStart();
    I2CWrByte(0x8f); // Open display, maximum brightness
    I2Cask();
    I2CStop();
}

//=====================================================
void main()
{ 
    int flag = 1;
	unsigned char testVal = 0x55; // խ
    unsigned int addr, n; 
    unsigned char i;
    
    for(i=0; i<5; i++)
    {
        num[i] = 10;
        DisplayNum(num);   //Clear TM1637
    }

    for(addr = RAM_START; addr <= RAM_END; addr++) 
    {
        //ܥثe} 
        if(addr % 10 == 0)
        {
            n = (int)(addr/10);
            num[4] = n % 10;
            n = (int)(n/10);
            num[3] = n % 10;
            n = (int)(n/10);
            num[2] = n % 10;
            n = (int)(n/10);
            num[1] = n % 10;
            DisplayNum(num);
        }
        XBYTE[addr] = testVal;      // gJխ
        if(XBYTE[addr] != testVal)  // Ūˬd
		    flag = 0;			
		XBYTE[addr] = ~testVal;      // gJխ
        if(XBYTE[addr] != ~testVal)  // Ūˬd
		    flag = 0;
      
        if(!flag)
            break;  //~hXAܰdb}
    }
	while(1);	//wait here	 
}

